clear all
close all

NFOV = 16;
NumImage = 751; % Number of images in each dax
StepInterval = 5; % frames to wait at each height for each channel
TotalNumChannels = 3; % total number of channels in the multi-channel z stack
ImageSize = 1536; % number of pxls
NumberOfFramesPerZ = 3;
FirstCenterFrameIndex = 5;
% AdaptiveThresholdingSensitivity = 0.05;

mkdir('DAPI_2Kb_WO_pAb')
DAPI_Intensity = [];
Biotin_U_Intensity =[];
Biotin_DAPI_Ratio =[];
TotalCellCount = 0;

for jj = 0:NFOV-1

    if NFOV<10
        FOVid = num2str(jj);
    elseif NFOV>=10 && NFOV<=100
        if jj<10
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    elseif NFOV>100
        if jj<10
            FOVid = ['00' num2str(jj)];
        elseif jj<100
            FOVid = ['0' num2str(jj)];
        else
            FOVid = [num2str(jj)];
        end
    end
        FileName = ['F:/12212023_PHR1_Resolution_65degWash_45FormamideWash/2Kb_WO_pAb/STORMCy3_0_' FOVid];
        [ImageStack_moving, InfoFile_moving] = ReadZStack_MultiChannel_Optimized(FileName, NumImage, ImageSize, StepInterval, TotalNumChannels, 3, NumberOfFramesPerZ, FirstCenterFrameIndex);

        I_moving = mean(ImageStack_moving,3);
        I_moving = I_moving/max(max(I_moving));
        I_moving = medfilt2(I_moving);
        BW = imbinarize(I_moving,'adaptive','Sensitivity',0.4);
        BW2 = imfill(BW,'holes');
        SS = regionprops(BW2, 'Area');
        MaxOutliersPixes = round(max([SS.Area])/10);
        BW3 = bwareaopen(BW2,MaxOutliersPixes);
        SSS = regionprops(BW3, 'Area');
        SSSS = regionprops(BW3, 'Circularity','PixelList');
        BW4 = BW3;
        for i =1:length([SSSS.Circularity])
            if SSSS(i).Circularity<0.7
               for ii=1:length([SSSS(i).PixelList(:,2)])
                  BW4(SSSS(i).PixelList(ii,2),SSSS(i).PixelList(ii,1)) = 0;
               end
            end
        end
       SSSSS = regionprops(BW4, 'Area');
       MaxOutliersPixes = ceil(mean([SSSSS.Area])/1.2);
       BW5 = bwareaopen(BW4,MaxOutliersPixes);
        
        
        [L,CellNumber] = bwlabel(BW5);
        TotalCellCount = TotalCellCount + CellNumber;
        
        
        figure(2)
        imagesc(BW5) % plot the openned image
        colormap gray
        axis equal
        saveas(gcf, ['DAPI_2Kb_WO_pAb/DAPI_Clean_' [num2str(jj)] '.jpg']);
        
       for iii = 1:CellNumber
           CellListName = ['cell' [num2str(iii)]];
           [y,x] = find(L==iii);
           Coordinate = {[y,x]};
           CellList.(CellListName) = Coordinate;
       end     
        
       save(['DAPI_2Kb_WO_pAb/CellList' FOVid '.mat'], 'CellList');
       
       
%        
       clear CellList;

end








